/*********************************************************************/
/* Project Name: TPM.mcp                                             */
/* Source fle name: TPM.c                                            */
/*********************************************************************/
/* Copyright (C) 2007 Freescale Semiconductor, Inc.                  */
/* All Rights Reserved                                               */
/*********************************************************************/
/*********************************************************************/
/* Hands on training for QE128 MCU's                                 */
/* Module: TPWM using timer output compare functionality             */
/* The firmware was developed and tested on CodeWarrior 6.0 version  */
/*                                                                   */
/* Description: The timer is configured to count up to 0xFFFF        */
/* when an overflow is ocurred PTE0 toggles.                         */
/*********************************************************************/
/*                                                                   */
/* Date: 12/03/2007                                                  */
/* Ulises Corrales Salgado                                           */
/* Application Engineer                                              */
/* RTAC Americas                                                     */
/*********************************************************************/                                                                      

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

/*********************************************************************/
/*  Function declarations                                            */
/*********************************************************************/

void MCU_Init(void) {
  
 SOPT1 = 0x23;          /* Watchdog disable. Stop Mode Enable. Background Pin enable. RESET pin enable */  
 SCGC1 = 0x80;          /* Bus Clock to the TPM3 module is enabled */
 SCGC2 = 0x00;          /* Disable Bus clock to unused peripherals */
}

void GPIO_Init(void) { 
  
 PTCDD = 0x03;          /* Configure PTC0, and PTC1 as outputs */
 PTCD = 0x00;           /* Put 0's in PTC0 port */
}

void TPM_configuration (void) {
 TPM3MOD = 0xFFFF;      /* The counter counts up to 0xFFFF */
 TPM3C0V = 0x0000;      /* The channel interrupt will happen when counter matches */
 TPM3C0SC = 0x54;       /* Channel interrupt enabled and configured as toggle output on compare */
 TPM3SC = 0x0F;         /* TPM clock source is: Bus rate clock divided by 128 */
}

/*********************************************************************/
/*  Main Function                                                    */
/*********************************************************************/

void main(void) {

  MCU_Init();       /* Function that initializes the MCU */
  GPIO_Init();      /* Function that initializes the Ports of the MCU */
  TPM_configuration();  /* Function that initializes the TPM module */
  
  
  EnableInterrupts; /* enable interrupts */
  
  for(;;) {

  } /* loop forever */
  /* please make sure that you never leave this function */
}                                    


void interrupt VectorNumber_Vtpm3ch0 TPM_ISR(void) {

  TPM3C0SC_CH0F;                /* Clears timer flag */
  TPM3C0SC_CH0F = 0;
  
  PTCD_PTCD1 ^= 1;              /* At this point will toggle PTC0 and PTC1. PTC0 will toggle every time */
                                /* an interrupt is generated because the TPM3C0 pin is in PTC0. PTC1 will */
                                /* toggle with the instruction PTCD_PTCD1 ^= 1; */
}